
use <../../openscad/libs/utilities.scad>
use <../../openscad/libs/microscope_parameters.scad>
use <../../openscad/libs/libdict.scad>
use <../../openscad/libs/z_axis.scad>
use <../../openscad/libs/main_body_structure.scad>
use <../librender/rendered_separate_z_actuator.scad>

// design motion angle is 6 degrees. Avoid contact at 7 degrees.
ANGLE=7;

translate_x(-50){
    rotate_z(-45){
        legs_rom(angle=ANGLE);
    }
}

translate_x(50){
    z_axis_casing_rom(angle=ANGLE);
}

$vpt = [ 0, 25, 30 ];
$vpr = [ 50, 0, 0 ];
$vpd = 300;

module leg_volume(axis=1, angle=7){
        params=default_params();
        rotate_z(axis*45){
            translate_y(key_lookup("leg_r", params)){
                // hull(){ // Using hull() here will mean that any cut-out on the legs will be filled back in
                    rotate_x(angle){
                        rotate_y(axis*angle){
                            actuator_leg(params);
                        }
                    }
                    rotate_x(-angle){
                        rotate_y(axis*angle){
                            actuator_leg(params);
                        }
                    }
                // }
            }
        }
    }

module legs_rom(angle=7){
    cut_color = (angle < 7.01)? "red" : "blue" ;
    difference(){
        color("lightgrey"){
            leg_volume(axis=1, angle=angle);
        }
        color(cut_color){
            union(){
                z_axis_casing(params=default_params(), cable_housing = false);
                translate_z(2) {
                    z_axis_struts(params=default_params());
                }
            }
        }
    }
}

module z_axis_casing_rom(angle=7){
    cut_color = (angle < 7.01)? "red" : "blue" ;
    difference(){
        color("lightgrey") 
            union(){
                z_axis_casing(params=default_params(), cable_housing = false);
                // add the z-axis struts in the raised position
                // Raised not angled is a worst case
                translate_z(2){
                    z_axis_struts(params=default_params());
                }
            }
        color(cut_color){
            leg_volume(axis=1, angle=angle);
            // both sides can cause OpenSCAD preview to fail
            leg_volume(axis=-1, angle=angle);
        }
    }
}
